// path.java
// demonstracja wyszukiwania najkrtszej cieki w waonym grafie skierowanym
// aby uruchomi program: C:>java PathApp (wersja angielska)
// aby skompilowa wersj polsk: C:>javac path.java
// po kompilacji:         C:>java PathApp
////////////////////////////////////////////////////////////////
class DistPar             // odlego i rodzic
   {                      // elementy przechowywane w tablicy sPath
   public int distance;   // odlego od pocztku do tego wierzchoka
   public int parentVert; // biecy rodzic tego wierzchoka
// -------------------------------------------------------------
   public DistPar(int pv, int d)  // konstruktor
      {
      distance = d;
      parentVert = pv;
      }
// -------------------------------------------------------------
   }  // end class DistPar
///////////////////////////////////////////////////////////////
class Vertex
   {
   public char label;        // etykieta (np. 'A')
   public boolean isInTree;
// -------------------------------------------------------------
   public Vertex(char lab)   // konstruktor
      {
      label = lab;
      isInTree = false;
      }
// -------------------------------------------------------------
   }  // end class Vertex
////////////////////////////////////////////////////////////////
class Graph
   {
   private final int MAX_VERTS = 20;
   private final int INFINITY = 1000000;
   private Vertex vertexList[]; // lista wierzchokw
   private int adjMat[][];      // matryca przylegania
   private int nVerts;          // bieca liczba wierzchokw
   private int nTree;           // liczba wierzchokw w drzewie
   private DistPar sPath[];     // tablica danych najkrtszej cieki
   private int currentVert;     // biecy wierzchoek
   private int startToCurrent;  // odlego do biecego wierzchoka
// -------------------------------------------------------------
   public Graph()               // konstruktor
      {
      vertexList = new Vertex[MAX_VERTS];
                                         // matryca przylegania
      adjMat = new int[MAX_VERTS][MAX_VERTS];
      nVerts = 0;
      nTree = 0;
      for(int j=0; j<MAX_VERTS; j++)     // ustaw matryc
         for(int k=0; k<MAX_VERTS; k++)  //     przylegania na
            adjMat[j][k] = INFINITY;     //     wartoci nieskoczone
      sPath = new DistPar[MAX_VERTS];    // najkrtsze cieki
      }  // end constructor
// -------------------------------------------------------------
   public void addVertex(char lab)
      {
      vertexList[nVerts++] = new Vertex(lab);
      }
// -------------------------------------------------------------
   public void addEdge(int start, int end, int weight)
      {
      adjMat[start][end] = weight;  // (skierowany)
      }
// -------------------------------------------------------------
   public void path()                // znajd wszystkie najkrtsze cieki
      {
      int startTree = 0;             // rozpocznij od wierzchoka 0
      vertexList[startTree].isInTree = true;
      nTree = 1;                     // umie w drzewie

      // przenie wiersz odlegoci z adjMat do sPath
      for(int j=0; j<nVerts; j++)
         {
         int tempDist = adjMat[startTree][j];
         sPath[j] = new DistPar(startTree, tempDist);
         }

      // a do zapisania wszystkich wierzchokw w drzewie
      while(nTree < nVerts)
         {
         int indexMin = getMin();    // pobierz z sPath warto minimaln
         int minDist = sPath[indexMin].distance;

         if(minDist == INFINITY)     // jeeli wszystkie nieskoczone
            {                        // lub w drzewie,
            System.out.println("Wykryto wierzchoki niedostpne");
            break;                   // sPath kompletna
            }
         else
            {                        // zeruj wierzchoek biecy
            currentVert = indexMin;  // przypisz wierzchoek najbliszy
            startToCurrent = sPath[indexMin].distance;
            // biecy wierzchoek ma najmniejsz odlego od pocztku drzewa
            // odlego wynosi startToCurrent
            }
         // zapisz wierzchoek w drzewie
         vertexList[currentVert].isInTree = true;
         nTree++;
         adjust_sPath();             // uaktualnij tablic sPath[]
         }  // end while (liczba wierzchokw w drzewie < liczba wierzchokw)

      displayPaths();                // wywietl zawarto tablicy sPath[]

      nTree = 0;                     // zeruj drzewo
      for(int j=0; j<nVerts; j++)
         vertexList[j].isInTree = false;
      }  // end path()
// -------------------------------------------------------------
   public int getMin()               // pobierz wpis z tablicy sPath
      {                              //    o najmniejszej odlegoci
      int minDist = INFINITY;        // pocztkowa odlego minimalna
      int indexMin = 0;
      for(int j=1; j<nVerts; j++)    // dla kadego wierzchoka,
         {                           // jeeli jest w drzewie i
         if( !vertexList[j].isInTree &&  // odlego jest mniejsza ni poprzednia
                               sPath[j].distance < minDist )
            {
            minDist = sPath[j].distance;
            indexMin = j;            // uaktualnij minimum
            }
         }  // end for
      return indexMin;               // zwr indeks wpisu
      }  // end getMin()
// -------------------------------------------------------------
   public void adjust_sPath()
      {
      // popraw wartoci w tablicy najkrtszych cieek sPath
      int column = 1;                // pomi wierzchoek pocztkowy
      while(column < nVerts)         // kolejne kolumny
         {
         // jeeli wierzchoek odpowiadajcy tej kolumnie jest ju w drzewie, pomi go
         if( vertexList[column].isInTree )
            {
            column++;
            continue;
            }
         // oblicz odlego dla jednego wpisu sPath
            // pobierz krawd od biecego wierzchoka do wierzchoka odpowiadajcego kolumnie
         int currentToFringe = adjMat[currentVert][column];
            // dodaj odlego od pocztku
         int startToFringe = startToCurrent + currentToFringe;
            // pobierz odlego biecego wpisu sPath
         int sPathDist = sPath[column].distance;

         // porwnaj odlego od pocztku z wpisem sPath
         if(startToFringe < sPathDist)   // jeeli krtsza,
            {                            // uaktualnij sPath
            sPath[column].parentVert = currentVert;
            sPath[column].distance = startToFringe;
            }
         column++;
         }  // end while (nr kolumny < liczba wierzchokw)
   }  // end adjust_sPath()
// -------------------------------------------------------------
   public void displayPaths()
      {
      for(int j=0; j<nVerts; j++) // wywietl zawarto sPath[]
         {
         System.out.print(vertexList[j].label + "="); // B=
         if(sPath[j].distance == INFINITY)
            System.out.print("inf");                  // nieskoczono
         else
            System.out.print(sPath[j].distance);      // 50
         char parent = vertexList[ sPath[j].parentVert ].label;
         System.out.print("(" + parent + ") ");       // (A)
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   }  // end class Graph
////////////////////////////////////////////////////////////////
class PathApp
   {
   public static void main(String[] args)
      {
      Graph theGraph = new Graph();
      theGraph.addVertex('A');     // 0  (pocztek)
      theGraph.addVertex('B');     // 1
      theGraph.addVertex('C');     // 2
      theGraph.addVertex('D');     // 3
      theGraph.addVertex('E');     // 4

      theGraph.addEdge(0, 1, 50);  // AB 50
      theGraph.addEdge(0, 3, 80);  // AD 80
      theGraph.addEdge(1, 2, 60);  // BC 60
      theGraph.addEdge(1, 3, 90);  // BD 90
      theGraph.addEdge(2, 4, 40);  // CE 40
      theGraph.addEdge(3, 2, 20);  // DC 20
      theGraph.addEdge(3, 4, 70);  // DE 70
      theGraph.addEdge(4, 1, 50);  // EB 50

      System.out.println("Najkrtsze cieki");
      theGraph.path();             // najkrtsze cieki
      System.out.println();
      }  // end main()
   }  // end class PathApp
////////////////////////////////////////////////////////////////

